<?php
use AmazonPayApiSdkExtension\Struct\CheckoutSession;
use AmazonPayApiSdkExtension\Struct\StatusDetails;
use OncoAmazonPay\ApiService;
use OncoAmazonPay\LogService;
use OncoAmazonPay\TransactionService;
use OncoAmazonPay\Utils;

class AmazonPay_CheckoutSuccessThemeContentView extends AmazonPay_CheckoutSuccessThemeContentView_parent
{
    public function prepare_data()
    {
        parent::prepare_data();

        $orderId = $this->order_id;
        if ($orderId) {
            $order = MainFactory::create('order', $orderId);
            if ($order) {
                if ($order->info['payment_method'] == 'amazon_pay') {
                    $transactionService = new TransactionService();
                    $transactions = $transactionService->getTransactionsOfOrder($orderId);
                    if(empty($transactions)) {
                        $this->set_content_data('AMAZON_PAY_ERROR', TEXT_AMAZON_PAY_CHECKOUT_SUCCESS_ERROR);
                    }
                }
            }
        }

    }


}